import Image from "next/image";
import Link from "next/link";
import Navbar from "@/components/Navbar";
import Sidebar from "@/components/Menu";

export default function DashboardLayout({
    children,
  }: Readonly<{
    children: React.ReactNode;
  }>) {
    return ( 
    <div className="h-screen flex">
      {/*LEFT*/}
      <div className="w-[260px] bg-slate-300 ">
        
        <Sidebar/>
      </div>
      {/*RIGHT*/}
      <div className="flex-1  bg-slate-200 overflow-scroll">
        <Navbar/>
        {children}
      </div>    
    </div>
    );
  }
  