import "./globals.css";

import { AuthProvider } from "../context/AuthContext";
import type { Metadata } from "next";
import { Poppins } from "next/font/google";
import { UserProvider } from "../context/useCurrentUser";

const poppins = Poppins({
  subsets: ["latin"],
  weight: ["400", "500", "600", "700"], // Match what you were using
  display: "swap", // Optional, better performance
  variable: "--font-poppins", // For custom use in Tailwind or CSS
});

export const metadata: Metadata = {
  title: "AIC Milimani Church Dashboard",
  description: "Next.js Church Dashboard",
};

export default function RootLayout({
  children,
}: Readonly<{ children: React.ReactNode }>) {
  return (
    <html lang="en" className={poppins.variable}>
      <body className="font-sans">
        <AuthProvider>
          <UserProvider>{children}</UserProvider>
        </AuthProvider>
      </body>
    </html>
  );
}
