"use client";

import {
  Bar,
  BarChart,
  CartesianGrid,
  Legend,
  ResponsiveContainer,
  Tooltip,
  XAxis,
  YAxis,
} from "recharts";

import Image from "next/image";

const data = [
  { name: "Jan", Members: 500, Visitors: 100 },
  { name: "Feb", Members: 600, Visitors: 150 },
  { name: "Mar", Members: 620, Visitors: 120 },
  { name: "Apr", Members: 700, Visitors: 50 },
  { name: "May", Members: 750, Visitors: 200 },
  { name: "Jun", Members: 780, Visitors: 200 },
  { name: "Jul", Members: 600, Visitors: 150 },
];

const AttendanceChart = () => {
  return (
    <div className="bg-gradient-to-br from-white to-yellow-50 rounded-md p-6 shadow-md">
      {/* Header */}
      <div className="flex justify-between items-center mb-4">
        <h1 className="text-sm font-semibold text-gray-800">Attendance</h1>
        <Image src="/moreDark.png" alt="More options" width={20} height={20} />
      </div>

      {/* Chart */}
      <ResponsiveContainer width="100%" height={250}>
        <BarChart
          data={data}
          margin={{ top: 10, right: 30, left: 0, bottom: 5 }}
        >
          <CartesianGrid strokeDasharray="3 3" strokeOpacity={0.3} />
          <XAxis dataKey="name" tick={{ fill: "#374151" }} tickLine={false} />
          <YAxis tick={{ fill: "#374151" }} tickLine={false} />
          <Tooltip
            contentStyle={{
              backgroundColor: "#1F2937",
              color: "#ffffff",
              borderRadius: "8px",
            }}
          />
          <Legend
            verticalAlign="top"
            align="right"
            wrapperStyle={{ paddingBottom: "10px" }}
          />
          <Bar
            dataKey="Members"
            fill="#b91c1c"
            radius={[5, 5, 0, 0]}
            legendType="circle"
          />
          <Bar
            dataKey="Visitors"
            fill="#F4A261"
            radius={[5, 5, 0, 0]}
            legendType="circle"
          />
        </BarChart>
      </ResponsiveContainer>
    </div>
  );
};

export default AttendanceChart;
