import StoreIcon from "@mui/icons-material/Store";

const UserCard = ({ type, value }: { type: string; value: number }) => {
  return (
    <div className="relative rounded-md bg-gradient-to-br from-yellow-50 to-white p-5 flex-1 min-w-[180px] shadow-lg flex flex-col gap-3 overflow-hidden">
      {/* Background Circles */}
      <div className="absolute top-[-40px] right-[-40px] w-[120px] h-[120px] bg-yellow-200 rounded-full opacity-30"></div>
      <div className="absolute top-[-20px] right-[-10px] w-[80px] h-[80px] bg-yellow-300 rounded-full opacity-50"></div>

      {/* Icon with Material UI */}
      <div className="bg-yellow-100 p-3 rounded-md w-fit">
        <StoreIcon fontSize="large" className="text-yellow-600" />
      </div>

      {/* Numbers & Text */}
      <h2 className="text-xl font-bold text-gray-800">{value}</h2>
      <h3 className="text-gray-600 text-sm font-medium">{type}</h3>
    </div>
  );
};

export default UserCard;
