import { FaFacebook, FaInstagram, FaTwitter } from 'react-icons/fa';

const Footer = () => {
  return (
    <footer className="w-full bg-slate-100 text-gray-700 py-6 shadow-inner">
      <div className="flex flex-col items-center justify-center space-y-4">
        
        {/* Social Icons */}
        <div className="flex space-x-6">
          <a href="#" aria-label="Facebook" className="text-blue-600 hover:scale-110 transition-transform">
            <FaFacebook size={28} />
          </a>
          <a href="#" aria-label="Twitter" className="text-sky-500 hover:scale-110 transition-transform">
            <FaTwitter size={28} />
          </a>
          <a href="#" aria-label="Instagram" className="text-pink-500 hover:scale-110 transition-transform">
            <FaInstagram size={28} />
          </a>
        </div>

        {/* Copyright */}
        <p className="text-sm text-gray-600 text-center">
          &copy; {new Date().getFullYear()} AIC. All rights reserved.
        </p>
      </div>
    </footer>
  );
};

export default Footer;
