// components/navigation.ts

import DashboardIcon from '@mui/icons-material/Dashboard';
import EventIcon from '@mui/icons-material/Event';
import FavoriteIcon from '@mui/icons-material/Favorite';
import GroupsIcon from '@mui/icons-material/Groups';
import LogoutIcon from '@mui/icons-material/Logout';
import PeopleIcon from '@mui/icons-material/People';
import QuestionAnswerIcon from '@mui/icons-material/QuestionAnswer';
import SettingsIcon from '@mui/icons-material/Settings';
import VerifiedUserIcon from '@mui/icons-material/VerifiedUser';

export interface NavItem {
  label: string;
  href?: string;
  icon: React.ReactNode;
  visible: string[];
  logout?: boolean;
}

export interface NavSection {
  title: string;
  items: NavItem[];
}

export const NAVIGATION: NavSection[] = [
  {
    title: 'MENU',
    items: [
      { icon: <DashboardIcon />, label: 'Dashboard', href: '/dashboard/admin', visible: ['admin'] },
      { icon: <EventIcon />, label: 'Events', href: '/dashboard/list/events', visible: ['admin'] },
      { icon: <PeopleIcon />, label: 'Visitors', href: '/dashboard/list/visitors', visible: ['admin'] },
      { icon: <GroupsIcon />, label: 'Cell group', href: '/dashboard/list/cellGroups', visible: ['admin'] },
      { icon: <FavoriteIcon />, label: 'Prayer requests', href: '/dashboard/list/prayers', visible: ['admin'] },
      { icon: <VerifiedUserIcon />, label: 'Membership', href: '/dashboard/list/members', visible: ['admin'] },
      { icon: <QuestionAnswerIcon />, label: 'Inquiries', href: '/dashboard/list/inquiries', visible: ['admin'] },
      { icon: <SettingsIcon />, label: 'Settings', href: '/dashboard/list/settings', visible: ['admin'] },
      { icon: <LogoutIcon />, label: 'Logout', href:'/Homepage', visible: ['admin'], logout: true },
    ],
  },
];
